!!ARBvp1.0
# bump__SPEC.vsh

TEMP r0, r1, r2, bn;

PARAM c[13] = {program.env[0..12]};
PARAM c0 = {0.3, 0.5, 2.0, 0.0};
PARAM c1 = {1.0, 1.0, 1.0, 1.0};

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.normal;
ATTRIB v2 = vertex.attrib[6];	# Tangent
ATTRIB v3 = vertex.texcoord[0];

ALIAS oPos = result.position;
ALIAS oD0 = result.color.primary;
ALIAS oD1 = result.color.secondary;
ALIAS oT0 = result.texcoord[0];
ALIAS oT1 = result.texcoord[1];

# transform position
DP4 oPos.x, v0, c[4];
DP4 oPos.y, v0, c[5];
DP4 oPos.z, v0, c[6];
DP4 oPos.w, v0, c[7];

# Set tex coords.  Diffuse and bump map share same coords.
MOV oT0.xy, v3;
MOV oT1.xy, v3;

# Compute rescaled and negated binormal.
MUL r0, v2, c0.z;
MUL r1, -r0.zxyw, v1.yzxw;
MAD r1, -r0.yzxw, v1.zxyw, -r1;

# Compute non-flipped binormal -- cross-product of tangent and normal.
MUL r0, -v2.zxyw, v1.yzxw;
MAD r2, -v2.yzxw, v1.zxyw, -r0;
MOV r2, -r2;

# Choose flipped (r1) or non-flipped (r2) based on tangent length.
DP3 r0, v2, v2;
SLT r0, r0, c0.x;		# 1 if r0 < 0.3, else 0
MUL bn, r1, r0;			
SUB r0, c1, r0;
MAD bn, r2, r0, bn;

# Move sun direction into tangent space
DP3 r0.x, -v2, c[2];
DP3 r0.y,  bn, c[2];
DP3 r0.z,  v1, c[2];

# Range compress and place in color
MAD oD0.xyz, r0, c0.y, c0.y;

# Compute H vector
SUB r0.xyz, c[12], v0;		# sun position - vertex position
DP3 r2.w, r0, r0;			# normalize
RSQ r2.w, r2.w;
MUL r2, r2, r2.w;

# Move H vector into tangent space
DP3 r0.x, -v2, r2;
DP3 r0.y,  r1, r2;
DP3 r0.z,  v1, r2;

# Range compress and place in specular 
MAD oD1.xyz, r0, c0.y, c0.y;

END
